/*
Based on the traceray method of Blink v1.1 by Pinkfairie
*/

#pragma semicolon 1

//Includes:
#include <sourcemod>
#include <sdktools>

//Definitions:
#define PL_VERSION "1.1"

//Arrays
new walkUncrouched[137] = {2, 3, 4, 5, 7, 8, 10, 11, 13, 16, 
18, 20, 23, 26, 29, 32, 36, 39, 43, 47, 51, 55, 60, 65, 70, 75, 80, 
85, 91, 97, 102, 109, 115, 121, 128, 135, 142, 149, 156, 164, 172, 
180, 188, 196, 205, 213, 222, 231, 240, 250, 259, 269, 279, 289, 299, 
309, 320, 331, 342, 353, 364, 376, 388, 399, 412, 424, 436, 449, 462, 
475, 488, 501, 514, 528, 542, 556, 570, 585, 599, 614, 629, 644, 659, 
675, 691, 706, 722, 739, 755, 772, 788, 805, 822, 840, 857, 875, 892, 
910, 929, 947, 966, 984, 1003, 1022, 1042, 1061, 1081, 1100, 1120, 1141, 
1161, 1181, 1202, 1223, 1244, 1265, 1287, 1308, 1330, 1352, 1374, 1396, 
1419, 1442, 1465, 1488, 1511, 1534, 1558, 1582, 1605, 1630, 1654, 1678, 
1703, 1728, 1753};

new walkCrouched[126] = {0, 3, 6, 9, 12, 16, 19, 23, 27, 31, 35, 
40, 45, 50, 55, 60, 65, 71, 77, 82, 89, 95, 101, 108, 115, 122, 129, 
136, 144, 152, 160, 168, 176, 185, 193, 202, 211, 220, 230, 239, 249, 
259, 269, 279, 289, 300, 311, 322, 333, 344, 356, 368, 379, 392, 404, 
416, 429, 442, 455, 468, 481, 494, 508, 522, 536, 550, 565, 579, 594, 
609, 624, 639, 655, 671, 686, 702, 719, 735, 752, 768, 785, 802, 820, 
837, 855, 872, 890, 909, 927, 946, 964, 983, 1002, 1022, 1041, 1061, 
1080, 1100, 1121, 1141, 1161, 1182, 1203, 1224, 1245, 1267, 1288, 1310, 
1332, 1354, 1376, 1399, 1422, 1445, 1468, 1491, 1514, 1538, 1562, 1585, 
1610, 1634, 1658, 1683, 1708, 1733};

new jumpUncrouched[117] = {1, 5, 10, 14, 19, 24, 29, 35, 40, 46, 
52, 58, 64, 71, 77, 84, 91, 98, 106, 113, 121, 129, 137, 145, 154, 
162, 171, 180, 189, 199, 208, 218, 228, 238, 248, 259, 269, 280, 291, 
302, 313, 325, 337, 348, 360, 373, 385, 398, 410, 423, 437, 450, 463, 
477, 491, 505, 519, 533, 548, 563, 578, 593, 608, 624, 639, 655, 671, 
687, 704, 720, 737, 754, 771, 788, 806, 823, 841, 859, 877, 895, 914, 
933, 952, 971, 990, 1009, 1029, 1049, 1069, 1089, 1109, 1130, 1150, 
1171, 1192, 1213, 1235, 1256, 1278, 1300, 1322, 1345, 1367, 1390, 1413, 
1436, 1459, 1482, 1506, 1530, 1553, 1578, 1602, 1626, 1651, 1676, 1701};

new jumpCrouched[112] = {4, 9, 15, 20, 26, 32, 38, 44, 51, 57, 64, 
71, 78, 86, 93, 101, 109, 117, 125, 134, 142, 151, 160, 169, 179, 188, 
198, 208, 218, 228, 239, 249, 260, 271, 282, 293, 305, 317, 328, 340, 
353, 365, 378, 390, 403, 417, 430, 443, 457, 471, 485, 499, 513, 528, 
543, 558, 573, 588, 604, 619, 635, 651, 667, 684, 700, 717, 734, 751, 
768, 786, 803, 821, 839, 857, 875, 894, 913, 932, 951, 970, 989, 1009, 
1029, 1049, 1069, 1089, 1110, 1130, 1151, 1172, 1193, 1215, 1236, 1258, 
1280, 1302, 1325, 1347, 1370, 1393, 1416, 1439, 1462, 1486, 1510, 1533, 
1558, 1582, 1606, 1631, 1656, 1681};

new ctapUncrouched[121] = {2, 5, 9, 13, 17, 21, 25, 30, 35, 40, 45, 
50, 55, 61, 67, 73, 79, 86, 92, 99, 106, 113, 120, 128, 135, 143, 151, 
159, 168, 176, 185, 194, 203, 212, 221, 231, 241, 251, 261, 271, 282, 
293, 303, 314, 326, 337, 349, 361, 372, 385, 397, 409, 422, 435, 448, 
461, 475, 488, 502, 516, 530, 544, 559, 573, 588, 603, 618, 634, 649, 
665, 681, 697, 713, 730, 746, 763, 780, 797, 815, 832, 850, 868, 886, 
904, 923, 941, 960, 979, 998, 1018, 1037, 1057, 1077, 1097, 1117, 1137, 
1158, 1179, 1200, 1221, 1242, 1264, 1285, 1307, 1329, 1351, 1374, 1396, 
1419, 1442, 1465, 1489, 1512, 1536, 1559, 1583, 1608, 1632, 1657, 1681, 
1706};

new ctapCrouched[116] = {1, 5, 10, 15, 20, 25, 30, 35, 41, 47, 53, 
59, 66, 72, 79, 86, 93, 100, 108, 115, 123, 131, 139, 148, 156, 165, 
174, 183, 192, 201, 211, 221, 231, 241, 251, 262, 273, 283, 294, 306, 
317, 329, 341, 352, 365, 377, 389, 402, 415, 428, 441, 455, 468, 482, 
496, 510, 524, 539, 553, 568, 583, 598, 614, 629, 645, 661, 677, 693, 
710, 726, 743, 760, 777, 795, 812, 830, 848, 866, 884, 903, 921, 940, 
959, 978, 998, 1017, 1037, 1057, 1077, 1097, 1117, 1138, 1159, 1180, 
1201, 1222, 1244, 1265, 1287, 1309, 1331, 1354, 1376, 1399, 1422, 1445, 
1469, 1492, 1516, 1539, 1563, 1588, 1612, 1637, 1661, 1686};

new arraySizes[6] = {136, 125, 116, 111, 120, 115};
new String:display1[32];
new String:display2[32];
new String:display3[32];
new String:display4[32];
new String:display5[32];
new String:display6[32];
new String:result1[4];
new String:result2[4];
new String:result3[4];
new String:result4[4];
new String:result5[4];
new String:result6[4];
new String:bTitle[32];
new roundHeight;

//Information:
public Plugin:myinfo =
{
	name = "Bounce Checker",
	author = "Rob123",
	description = "[TF2] Checks block at cursor for bounce compatibility",
	version = PL_VERSION,
	url = "http://tf2jump.com"
}

//Initation:
public OnPluginStart()
{
	RegConsoleCmd("sm_bcheck", Command_Bcheck, "Checks bounces for where you are aiming!");
}

public Action:Command_Bcheck(client, args){
	if( !client ){
		ReplyToCommand(client, "[SM] Cannot check bounces from rcon");
		return Plugin_Handled;
	}
		
	decl Float:vAngles[3];
	decl Float:vOrigin[3];
	decl Float:vStart[3];
	decl Float:exactHeight;
    
    //get current position and angle
	GetClientEyePosition(client,vOrigin);
	GetClientEyeAngles(client, vAngles);
	
    //get endpoint for teleport
	new Handle:trace = TR_TraceRayFilterEx(vOrigin, vAngles, MASK_SHOT, RayType_Infinite,TraceEntityFilterPlayer);
    	
	if(TR_DidHit(trace))
	{   	 
   	 	TR_GetEndPosition(vStart, trace);
        exactHeight = vOrigin[2] - vStart[2] - 68.0; //Subtract 75 because pos it at player's eyes, not feet
        roundHeight = RoundToNearest(exactHeight);
        if (roundHeight > 1800 || roundHeight < -1)
        {
            PrintToChat(client, "\x04[Bcheck]\x01 %s", "Height needs to be in range of 1 to 1800 units");
            CloseHandle(trace);
            return Plugin_Handled;
        }
        // Check if in array and return 1 or 0. Then turn 1 or 0 into Yes or No
        checkYes(result1, isInArray(walkUncrouched, roundHeight, 0));
        checkYes(result2, isInArray(walkCrouched, roundHeight, 1));
        checkYes(result3, isInArray(jumpUncrouched, roundHeight, 2));
        checkYes(result4, isInArray(jumpCrouched, roundHeight, 3));
        checkYes(result5, isInArray(ctapUncrouched, roundHeight, 4));
        checkYes(result6, isInArray(ctapCrouched, roundHeight, 5));
        //Format menu items
        Format(bTitle, sizeof(bTitle), "Bounce Checker\nHeight: %d", roundHeight);
        Format(display1, sizeof(display1), "Walk Uncrouched  -- %s", result1);
        Format(display2, sizeof(display2), "         Crouched      -- %s", result2);
        Format(display3, sizeof(display3), "Jump Uncrouched -- %s", result3);
        Format(display4, sizeof(display4), "          Crouched     -- %s", result4);
        Format(display4, sizeof(display4), "          Crouched     -- %s", result4);
        Format(display5, sizeof(display5), "Ctap Uncrouched  -- %s", result5);
        Format(display6, sizeof(display6), "         Crouched      -- %s", result6);
        //Create menu
        new Handle:menuhandle = CreateMenu(MenuCallBack);
        SetMenuTitle(menuhandle, bTitle);
        AddMenuItem(menuhandle, "lines", "", ITEMDRAW_SPACER);
        AddMenuItem(menuhandle, "d1", display1);
        AddMenuItem(menuhandle, "d2", display2);
        AddMenuItem(menuhandle, "d3", display3);
        AddMenuItem(menuhandle, "d4", display4);
        AddMenuItem(menuhandle, "d5", display5);
        AddMenuItem(menuhandle, "d6", display6);
        SetMenuExitButton(menuhandle, true);
        DisplayMenu(menuhandle, client, 20);
		CloseHandle(trace);
	}
	else 
	{
		PrintToChat(client, "\x05[Bcheck]\x01 %s", "Couldn't find surface");
		CloseHandle(trace);
		return Plugin_Handled;
	}

	return Plugin_Handled;	
}

public MenuCallBack(Handle:menuhandle, MenuAction:action, Client, Position)
{
    if (action == MenuAction_End)
    {
        CloseHandle(menuhandle);
    }
}

public bool:TraceEntityFilterPlayer(entity, contentsMask)
{
	return entity > GetMaxClients() || !entity;
} 

public isInArray(bArray[], value, arrayChoice)
{
    new upper = arraySizes[arrayChoice];
    new i = 0;
    for (i; i < upper; i++)
    {
        if (bArray[i] == value)
        {
            return 1;
        }
    }
    return 0;
}

checkYes(String:buffer[], value) 
{
    if (value == 1)
    {
        Format(buffer, 4, "Yes"); 
        return;
    }
    Format(buffer, 4, "No "); 
    return; 
} 