#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <tf2>
#include <tf2_stocks>
#define PLUGIN_VERSION "0.0.1"

//#define MAX_PLAYERS 33

public Plugin:myinfo = {
	name = "TF2 Fov",
	author = "CrancK",
	description = "Fov Changer",
	version = PLUGIN_VERSION,
	url = ""
};

new offsFOV = -1;
new offsDefaultFOV = -1;
new fov[MAXPLAYERS];
new fov2[MAXPLAYERS];

new Handle:g_fovEnabled = INVALID_HANDLE;
new Handle:cvFovMax = INVALID_HANDLE;

public OnPluginStart() 
{
	CreateConVar("sm_fov_version", PLUGIN_VERSION, "fov Version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	g_fovEnabled = CreateConVar("sm_fovEnabled", "1.0", "allows changing of fov", FCVAR_PLUGIN|FCVAR_NOTIFY, true, 0.0, true, 1.0);
	cvFovMax = CreateConVar("sm_fovmax", "160", "set's the max limit for the fov command", FCVAR_PLUGIN|FCVAR_NOTIFY);
	
	RegConsoleCmd("sm_fov", Command_fov, "Set your FOV.");
	offsFOV = FindSendPropOffs("CBasePlayer", "m_iFOV");
	offsDefaultFOV = FindSendPropOffs("CBasePlayer", "m_iDefaultFOV");
}

public OnMapStart()
{
	for(new i=1;i<MaxClients+1;i++)
	{
		fov2[i] = -1;
	}
}

public OnClientPostAdminCheck(client) 
{
	fov[client] = GetEntData(client, offsFOV, 4);
	fov2[client] = -1;
}

public OnClientDisconnect(client)
{
	fov2[client] = -1;
}

public Action:Command_fov(client, args) 
{
	if(GetConVarInt(g_fovEnabled) == 1) {
		if(args>0) {
			new String:arg[32];
			GetCmdArg(1, arg, sizeof(arg));
			for(new i=0;i<strlen(arg);i++) 
			{
				if(!IsCharNumeric(arg[i])) 
				{
					ReplyToCommand(client, "Value must be an integer.");
					return Plugin_Handled;
				}
			}
			if(StringToInt(arg)<=0 || StringToInt(arg)>GetConVarInt(cvFovMax)) 
			{
				ReplyToCommand(client, "Value must be between 1 and %i.", GetConVarInt(cvFovMax));
				return Plugin_Handled;
			}
			
			fov2[client] = StringToInt(arg);
			SetEntData(client, offsFOV, fov2[client], 4, true);
			SetEntData(client, offsDefaultFOV, fov2[client], 4, true);
			ReplyToCommand(client, "FOV set to %i.", fov2[client]);
		} 
		else if(fov2[client]==-1) 
		{
			ReplyToCommand(client, "FOV: %i", fov[client]);
		} 
		else 
		{
			ReplyToCommand(client, "FOV: %i", fov2[client]);
		}
		return Plugin_Handled;
	}
	return Plugin_Continue;
}

public OnGameFrame()
{
	for(new i=1;i<MaxClients+1;i++)
	{
		
		 if(fov2[i]!=-1)
		{
			if(!IsFakeClient(i) && IsValidEntity(i))
			{
				SetEntData(i, offsFOV, fov2[i], 4, true);
				SetEntData(i, offsDefaultFOV, fov2[i], 4, true);
			}
		}
	}
}

