#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <tf2>
#include <tf2_stocks>

#include <smlib>
//#include <sdkhooks>

#define PLUGIN_VERSION "0.0.1"

public Plugin:myinfo = {
	name = "Speedometer",
	author = "CrancK",
	description = "Speedometer",
	version = PLUGIN_VERSION,
	url = ""
};

new bool:speedo[MAXPLAYERS];


new Handle:SpeedOMeter = INVALID_HANDLE;

new Handle:cvSpeedoEnabled = INVALID_HANDLE;
new Handle:cvSpeedoForced = INVALID_HANDLE;



public OnPluginStart() 
{
	CreateConVar("sm_speedo_version", PLUGIN_VERSION, "Speedometer Version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	
	cvSpeedoEnabled = CreateConVar("sm_speedo_enabled", "1", "enables plugin", FCVAR_PLUGIN);
	cvSpeedoForced = CreateConVar("sm_speedo_forced", "0", "forces speedo on for everyone", FCVAR_PLUGIN);
	
	RegConsoleCmd("sm_speedo", Command_Speedo);
	
	SpeedOMeter = CreateHudSynchronizer();
}

public OnMapStart()
{
	new bool:speedoOn = false; if(GetConVarInt(cvSpeedoForced)==1) speedoOn = true;
	for(new i=0;i<MaxClients+1;i++)
	{
		if(!speedoOn) speedo[i] = false; 
		else speedo[i] = true; 
	}
}

public OnClientDisconnect(client)
{
	if(GetConVarInt(cvSpeedoEnabled)>0)
	{
		new bool:speedoOn = false; if(GetConVarInt(cvSpeedoForced)==1) speedoOn = true;
		
		if(!speedoOn) { if(speedo[client]) speedo[client] = false; }
		else { if(!speedo[client]) speedo[client] = true; }
	}
}

public Action:Command_Speedo(client, args)
{
	if(GetConVarInt(cvSpeedoEnabled)>0)
	{
		if(!speedo[client]) { speedo[client] = true; ReplyToCommand(client, "Speedo ON"); }
		else { speedo[client] = false; ReplyToCommand(client, "Speedo OFF"); }
	}
	return Plugin_Handled;
}


public Action:OnPlayerRunCmd(client, &buttons, &impulse, Float:vel[3], Float:angles[3], &weapon)
{
	if(GetConVarInt(cvSpeedoEnabled)>0)
	{
		new Float:currentVel[3]; GetEntPropVector(client, Prop_Data, "m_vecVelocity", currentVel);
		new Float:currentSpd; currentSpd = SquareRoot( (currentVel[0]*currentVel[0]) + (currentVel[1]*currentVel[1]) );
		
		if(speedo[client])
		{
				SetHudTextParams(0.44, 0.67, 1.0, 255, 50, 50, 255);
				ShowSyncHudText(client, SpeedOMeter, "Speed: %.0f u/s", currentSpd);
		}
	}
}