#include <sourcemod>
#include <sdktools>
#include <sdkhooks>

#define PL_VERSION "1.0"
#define TAG "\x06[S-Check]\x01"
#define ROCKET_COUNT 5
#define ROCKET_ATTRIBUTES 10

#define TIME_CAP 2.0
#define SPREAD_CAP 300.0
#define ROCKETSHOW_DELAY 6.0

//Information:
public Plugin:myinfo =
{
    name = "Sync Checker [S-Check]",
    author = "Rob123",
    description = "[TF2] Provides stats about syncs",
    version = PL_VERSION,
    url = "http://jump.tf"
}

new bool:g_bEnabled[MAXPLAYERS+1];
new bool:g_bClientInJump[MAXPLAYERS+1];
new bool:g_bClientRocketsEmpty[MAXPLAYERS+1];
new bool:g_bQueueReset[MAXPLAYERS+1];
new bool:g_bShowingRockets[MAXPLAYERS+1];
new Float:g_fClientRockets[MAXPLAYERS+1][ROCKET_COUNT][ROCKET_ATTRIBUTES];


public OnPluginStart()
{
    RegConsoleCmd("sm_scheck", cmdShowStats, "Toggles Sync Stats");
    HookEvent( "player_hurt", PlayerHurt);
}


public Action:cmdShowStats(client, args)
{
    if (g_bEnabled[client])
    {
        g_bEnabled[client] = false;
        PrintToChat(client, "%s %s", TAG, "No longer displaying sync stats");
    } else {
        g_bEnabled[client] = true;
        PrintToChat(client, "%s %s", TAG, "Now displaying sync stats");
    }
    return Plugin_Handled;
}


public Action:TF2_CalcIsAttackCritical(client, weapon, String:weaponname[], &bool:result)
{
    if (g_bEnabled[client])
    {
        if (g_bQueueReset[client]) //This is their first rocket
        {
            ResetClientJumpingArray(client);
        }

        new Float:clientAngles[3];
        new Float:clientOrigin[3];
        new Float:vEnd[3];

        GetClientEyePosition(client,clientOrigin);
        GetClientEyeAngles(client, clientAngles);
        new Handle:solidTrace = TR_TraceRayFilterEx(clientOrigin, clientAngles, MASK_SHOT, RayType_Infinite,TraceEntityFilterPlayer);
        if(TR_DidHit(solidTrace))
        {
            TR_GetEndPosition(vEnd, solidTrace);
            new Float:distance = GetVectorDistance(clientOrigin, vEnd);
            new Float:time = distance / 1100.0;
            new Float:predictedhit = time + GetTickedTime();
            g_bClientRocketsEmpty[client] = false;
            for (new i=0; i<ROCKET_COUNT; i++)
            {
                new Float:test = g_fClientRockets[client][i][0];
                if (test == 0.0)
                {
                    g_fClientRockets[client][i][0] = predictedhit;
                    g_fClientRockets[client][i][1] = time;
                    g_fClientRockets[client][i][2] = vEnd[0];
                    g_fClientRockets[client][i][3] = vEnd[1];
                    g_fClientRockets[client][i][4] = vEnd[2];
                    g_fClientRockets[client][i][5] = clientOrigin[0];
                    g_fClientRockets[client][i][6] = clientOrigin[1];
                    g_fClientRockets[client][i][7] = clientOrigin[2];
                    g_fClientRockets[client][i][8] = clientAngles[0];
                    g_fClientRockets[client][i][9] = clientAngles[1];

                    return
                }
            }
        }
    }
}


public bool:TraceEntityFilterPlayer(entity, contentsMask)
{
    return entity > GetMaxClients() || !entity;
}


public PlayerHurt( Handle:hEvent, const String:strEventName[], bool:bHidden)
{
    new client = GetClientOfUserId(GetEventInt(hEvent, "userid"));
    if (g_bEnabled[client])
    {
        new attacker = GetClientOfUserId(GetEventInt(hEvent, "attacker"));
        if (client == attacker && (!g_bClientInJump[client]) && (!g_bClientRocketsEmpty[client]))
        {
            // Set client as jumping
            g_bClientInJump[client] = true;
            CreateTimer(1.0, ResetClientJumping, GetClientSerial(client));

            // Trigger the SendMenu for the client themselves
            SendMenu(client, client);
        }
    }
    for (new i = 1; i <= MaxClients; i++)
    {
        if ((i != client && g_bEnabled[i]))
        {
            if (IsClientInGame(i) && IsClientObserver(i))
            {
                new iSpecMode = GetEntProp(i, Prop_Send, "m_iObserverMode");
                if (iSpecMode == 4 || iSpecMode != 5)
                {
                    new iTarget = GetEntPropEnt(i, Prop_Send, "m_hObserverTarget");
                    if (iTarget == client)
                    {
                        SendMenu(i, client);
                    }
                }
            }
        }

    }
}


public Action:SendMenu(clienttoshow, any:client)
{
    new String:Title[32];
    new String:Divider[16];
    new String:smallDivider[8];
    Format(Divider, sizeof(Divider), "================");
    Format(smallDivider, sizeof(smallDivider), "------");

    new String:display[48];
    new String:display2[48];

    new Float:overallTime;
    new Float:overallSpread;
    new finalrocket;

    for (new i=0; i<ROCKET_COUNT; i++)
    {
        if (i == ROCKET_COUNT -1 && (!g_fClientRockets[client][i][0] == 0.0))
            {
                finalrocket = i;
                break;
            }
        if (g_fClientRockets[client][i][0] == 0)
        {
            finalrocket = i-1;
            break;
        }
    }
    if (finalrocket == 0)
    {
        g_bQueueReset[client] = true;
        return
    }

    new Handle:panel = CreatePanel();
    Format(Title, sizeof(Title), "Sync Checker - %i Rockets", finalrocket + 1);
    SetPanelTitle(panel, Title);
    DrawPanelText(panel, Divider);

    PrintToConsole(client, Divider);
    PrintToConsole(client, Title);
    PrintToConsole(client, Divider);

    //Find the final rockets TR_GetEndPosition
    decl finalDistanceVec[3];
    for (new i=2; i< 5; i++)
    {
        finalDistanceVec[i-2] = g_fClientRockets[client][finalrocket][i];
    }
    new float:finalrockettime = g_fClientRockets[client][finalrocket][0];

    //Cycle through rockets and add stats to menu
    for (new i=0; i<finalrocket; i++)
    {
        new float:rockettime = g_fClientRockets[client][i][0];
        new float:timegap = FloatSub(finalrockettime, rockettime);

        decl distanceVec[3];
        for (new j=2; j<5; j++)
        {
            distanceVec[j-2] = g_fClientRockets[client][i][j];
        }
        new Float:distancegap = GetVectorDistance(finalDistanceVec, distanceVec);

        Format(display, sizeof(display), "Rocket %i    Timing: %.3f", i + 1, timegap);
        Format(display2, sizeof(display2), "                  Spread: %.2f", distancegap);
        DrawPanelText(panel, display);
        DrawPanelText(panel, display2);
        DrawPanelText(panel, smallDivider);

        PrintToConsole(client, display);
        PrintToConsole(client, display2);
        PrintToConsole(client, smallDivider);

        //Adjust overall stats
        overallTime = FloatAdd(FloatAbs(timegap), overallTime);
        overallSpread = FloatAdd(distancegap, overallSpread);
    }

    //Format overall time diff
    new Float:overallTimeGap = FloatSub(TIME_CAP, overallTime);
    new Float:overallTimePer;
    if (overallTimeGap < 0.0)
    {
        overallTimePer == 0.0;
    }
    else
    {
        overallTimePer = FloatMul(FloatDiv(overallTimeGap, TIME_CAP), 100.0);
    }

    //format overall spread diff
    new Float:overallSpreadGap = FloatSub(SPREAD_CAP, overallSpread);
    new Float:overallSpreadPer;
    if (overallSpreadGap < 0.0)
    {
        overallSpreadPer == 0.0;
    }
    else
    {
        overallSpreadPer = FloatMul(FloatDiv(overallSpreadGap, SPREAD_CAP), 100.0);
    }

    //Format the menu
    Format(display, sizeof(display), "Overall  Timing: %.2f%", overallTimePer);
    Format(display2, sizeof(display2), "Overall  Aiming: %.2f%", overallSpreadPer);
    DrawPanelText(panel, display);
    DrawPanelText(panel, display2);
    DrawPanelText(panel, Divider);
    DrawPanelText(panel, " ");
    DrawPanelItem(panel, "View Rockets");
    DrawPanelItem(panel, "Sync Stats Help");
    DrawPanelItem(panel, "Rocket Viewer Help");
    DrawPanelItem(panel, "Close");
    SendPanelToClient(panel, clienttoshow, PanelHandler, 60);

    PrintToConsole(client, display);
    PrintToConsole(client, display2);
    PrintToConsole(client, Divider);

    //Queue rockets reset next time they shoot
    if (clienttoshow == client)
    {
        g_bQueueReset[client] = true;
    }

    CloseHandle(panel);
}


public Action:ResetClientJumping(Handle: Timer, any:serial)
{
    new client = GetClientFromSerial(serial); // Validate the client serial

    if (client == 0) // The serial is no longer valid, the player must have disconnected
    {
        return Plugin_Stop;
    }
    g_bClientInJump[client] = false;
    return Plugin_Handled;
}


public Action:ResetClientJumpingArray(client)
{
    if (client == 0) // The serial is no longer valid, the player must have disconnected
    {
        return Plugin_Stop;
    }

    // Reset the rocket array of the client
    for (new i=0; i<ROCKET_COUNT; i++)
        {
            for (new j=0; j<ROCKET_ATTRIBUTES; j++)
            {
                g_fClientRockets[client][i][j] = 0;
            }
        }
    g_bClientRocketsEmpty[client] = true;
    g_bQueueReset[client] = false;
    return Plugin_Handled;
}


public PanelHandler(Handle:menu, MenuAction:action, param1, param2)
{
    if (action == MenuAction_Select)
    {
        new iSpecMode, iTarget;
        if (param2 == 1)
        {
            if (IsClientInGame(param1) && IsClientObserver(param1) && g_bEnabled[param1])
            {
                iSpecMode = GetEntProp(param1, Prop_Send, "m_iObserverMode");

                // The client isn't spectating any one person, so ignore them.
                if (iSpecMode == 4 || iSpecMode == 5)
                {
                    // Find out who the client is spectating.
                    iTarget = GetEntPropEnt(param1, Prop_Send, "m_hObserverTarget");
                    ShowRockets(iTarget);
                    SendMenu(param1, iTarget);
                    return Plugin_Handled;
                }

            }
            else
            {
                ShowRockets(param1);
                SendMenu(param1, param1);
            }
        }
        if (param2 == 2)
        {
            StatsHelpMenu(param1);
        }
        if (param2 == 3)
        {
            ShowerHelpMenu(param1);
        }

    }
    return Plugin_Handled;
}


public Action:ShowRockets(client)
{
    if (g_bShowingRockets[client])
    {
        PrintToChat(client, "%s %s", TAG, "Already displaying rockets.");
        return Plugin_Handled;
    }
    else
    {
        g_bShowingRockets[client] = true;

        //Find the first rocket which hit
        new float:firstrocket;
        new float:finalrocket;
        new float:firstrockettime = g_fClientRockets[client][0][0];

        for (new i=0; i<ROCKET_COUNT; i++)
        {
            new float:rockettime = g_fClientRockets[client][i][0];
            if (g_fClientRockets[client][i][0] == 0)
            {
                finalrocket = i-1;
                break;
            }
            if (rockettime < firstrockettime) //This rocket hit before
            {
                firstrockettime = rockettime;
                firstrocket = i;
            }
            finalrocket = i;
        }

        //Cycle through rockets vs firstrocket
        for (new i=0; i<ROCKET_COUNT; i++)
        {
            if (g_fClientRockets[client][i][0] == 0) //no rocket
            {
                break;
            }
            new ent_rocket = -1;

            new Float:end[3];
            new Float:start[3];
            new Float:ang[3];
            new Float:result[3];

            new Float:rockettime = g_fClientRockets[client][i][0];
            new Float:duration = g_fClientRockets[client][i][1];
            new Float:timegap = FloatSub(rockettime, firstrockettime);
            new Float:timeper = FloatDiv(timegap, duration);

            end[0] = g_fClientRockets[client][i][2];
            end[1] = g_fClientRockets[client][i][3];
            end[2] = g_fClientRockets[client][i][4];
            start[0] = g_fClientRockets[client][i][5];
            start[1] = g_fClientRockets[client][i][6];
            start[2] = g_fClientRockets[client][i][7];
            ang[0] = g_fClientRockets[client][i][8];
            ang[1] = g_fClientRockets[client][i][9];

            MakeVectorFromPoints(end, start, result);
            ScaleVector(result, timeper);
            AddVectors(end, result, end);

            ent_rocket = CreateEntityByName("tf_projectile_rocket");

            if (i == finalrocket)
            {
                SetEntityRenderColor(ent_rocket, 255, 0, 0, 255);
            }
            if (i == firstrocket)
            {
                SetEntityRenderColor(ent_rocket, 0, 255, 0, 255);
            }

            SetEntDataEnt2(ent_rocket, FindSendPropInfo("CTFProjectile_Rocket", "m_hOwnerEntity"), client, true);
            SetEntData(ent_rocket, FindSendPropInfo("CTFProjectile_Rocket", "m_bCritical"), 1, 1, true);
            SetEntData(ent_rocket, FindSendPropInfo("CTFProjectile_Rocket", "m_iTeamNum"), GetClientTeam(client), true);
            SetEntDataVector(ent_rocket, FindSendPropInfo("CTFProjectile_Rocket", "m_angRotation"), ang, true);

            DispatchSpawn(ent_rocket);
            TeleportEntity(ent_rocket, end, NULL_VECTOR, NULL_VECTOR);
            SDKHook(ent_rocket, SDKHook_SetTransmit, Hook_Entity_SetTransmit);

            CreateTimer(ROCKETSHOW_DELAY, DestroyRocket, EntIndexToEntRef(ent_rocket));

        }
        PrintToChat(client, "%s Now showing %i rockets", TAG, finalrocket+1);
        CreateTimer(ROCKETSHOW_DELAY, SetShowingRockets, GetClientSerial(client));
        return Plugin_Handled;
    }
}


public Action:DestroyRocket(Handle:timer, any:ref)
{
    new entity  = EntRefToEntIndex(ref);
    if (entity != INVALID_ENT_REFERENCE)
    {
        AcceptEntityInput(entity, "Kill");
    }
}


public Action:SetShowingRockets(Handle:timer, any:serial)
{
    new client = GetClientFromSerial(serial); // Validate the client serial

    if (client == 0) // The serial is no longer valid, the player must have disconnected
    {
        return Plugin_Stop;
    }
    g_bShowingRockets[client] = false;
    return Plugin_Handled;
}


public Action:Hook_Entity_SetTransmit(entity, client)
{
    if (g_bEnabled[client])
    {
        return Plugin_Continue;
    }
    else
    {
        return Plugin_Handled;
    }
}


public Action:StatsHelpMenu(client)
{
    new Handle:panel = CreatePanel();

    SetPanelTitle(panel, "Sync Checker - Stats Help");
    DrawPanelText(panel, "=================\n");

    DrawPanelText(panel, "Each rocket is compared to your");
    DrawPanelText(panel, "'base' rocket (shot last on floor)\n ");

    DrawPanelText(panel, "Timing: seconds b/w each rocket");
    DrawPanelText(panel, "and base rocket, negative = early");
    DrawPanelText(panel, "Spread: Units between where rocket");
    DrawPanelText(panel, "and base rocket hits");
    DrawPanelText(panel, "Try get these close to 0\n ");

    DrawPanelText(panel, "Overall measures total timing");
    DrawPanelText(panel, "and spread, aim for 100%\n ");
    DrawPanelItem(panel, "Back");
    DrawPanelItem(panel, "Close");
    SendPanelToClient(panel, client, HelpPanelHandler, 60);
    CloseHandle(panel);
}


public Action:ShowerHelpMenu(client)
{
    new Handle:panel = CreatePanel();

    SetPanelTitle(panel, "Sync Checker - Showing Help");
    DrawPanelText(panel, "=================\n");

    DrawPanelText(panel, "Showing rockets helps visualise");
    DrawPanelText(panel, "what your rockets look like when");
    DrawPanelText(panel, "the first one hit the floor*");
    DrawPanelText(panel, "*This may not be your base rocket\n ");

    DrawPanelText(panel, "Rocket Colours:");
    DrawPanelText(panel, "Green: First rocket to hit");
    DrawPanelText(panel, "Red: Your base rocket\n ");

    DrawPanelText(panel, "Rockets may appear far away after");
    DrawPanelText(panel, "a badly timed sync due to extrapolation\n ");
    DrawPanelItem(panel, "Back");
    DrawPanelItem(panel, "Close");
    SendPanelToClient(panel, client, HelpPanelHandler, 60);
    CloseHandle(panel);
}


public HelpPanelHandler(Handle:menu, MenuAction:action, param1, param2)
{
    if (action == MenuAction_Select)
    {
        new iSpecMode, iTarget;
        if (param2 == 1)
        {
            if (IsClientInGame(param1) && IsClientObserver(param1) && g_bEnabled[param1])
            {
                iSpecMode = GetEntProp(param1, Prop_Send, "m_iObserverMode");

                // The client isn't spectating any one person, so ignore them.
                if (iSpecMode == 4 || iSpecMode == 5)
                {
                    // Find out who the client is spectating.
                    iTarget = GetEntPropEnt(param1, Prop_Send, "m_hObserverTarget");
                    SendMenu(param1, iTarget);
                    return Plugin_Handled;
                }

            }
            else
            {
                SendMenu(param1, param1);
                return Plugin_Handled;
            }
        }
    }
    return Plugin_Handled;
}
